<?php include_once('../../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Orçamento</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Theme style -->
  <link rel="stylesheet" href="../dist/css/adminlte.min.css?versao=3.2511.19.1">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="../plugins/fontawesome-free/css/all.min.css?versao=3.2511.19.1">
  <!-- Google Font: Source Sans Pro -->
  <link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,600,700,400italic' rel='stylesheet' type='text/css'>

  <link rel="stylesheet" type="text/css" href="../dist/css/dataTables.bootstrap4.min.css?versao=3.2511.19.1" />

  <link href='../dist/css/bootstrap.min.css?versao=3.2511.19.1'>
  <link rel="stylesheet" href="../dist/css/custom.css?versao=3.2511.19.1">
  <link rel="stylesheet" href="../dist/css/sisplan.css?versao=3.2511.19.1">
  <link rel="stylesheet" type="text/css" href="../plugins/datatables-keytable/css/keyTable.bootstrap4.min.css?versao=3.2511.19.1">
  <link rel="stylesheet" type="text/css" href="../dist/css/responsive.bootstrap.min.css?versao=3.2511.19.1">
  <link rel="shortcut icon" href="../favicon.ico">
  <!-- Toastr -->
  <link rel="stylesheet" href="../plugins/toastr/toastr.min.css?versao=3.2511.19.1">
  <link rel="stylesheet" type="text/css" href="../dist/css/driver.min.css?versao=3.2511.19.1" />
  <link rel="stylesheet" href="../dist/css/jquery-ui.css?versao=3.2511.19.1">
  <link rel="stylesheet" href="../dist/css/cadastro.css?versao=3.2511.19.1">
  <!-- Google Font: Source Sans Pro -->
  <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">

  <style>
    #progressbar li {
      list-style-type: none;
      font-size: 12px;
      width: 25%;
      float: left;
      position: relative
    }

    .card-totais {
      margin-top: 2%;
    }

    #txtDados {
      padding-top: .7%;
      padding-left: .85%;
    }

    .input-group-append>a>i {
      margin-left: 0 !important;
      padding-left: 5px;
      padding-right: 5px;
    }

    .focus:read-only:focus {
      border-color: #aa1212 !important;
    }

    .border-Field .textoBorda {
      font-size: 1.0em !important;
      text-align: left !important;
      width: auto;
      padding: 0 10px;
      border-bottom: none;
    }

    .border-Field {
      border: 1.0px solid var(--font-color) !important;
      padding: 0 1.0em 1.0em 1.0em !important;
      margin: 0 0 1.0em 0 !important;
      -webkit-box-shadow: 0px 0px 0px 0px #000;
      box-shadow: 0px 0px 0px 0px #000;
      padding-bottom: 0px !important;
    }

    .disabledCaracteristica {
      background-color: var(--white-dark-disabled);
      font-weight: bold;
    }

    .divBtnItens {
      background-color: rgb(189 33 48) !important;
    }

    .linhaDesabilitada {
      pointer-events: none;
      opacity: 0.8;
      cursor: not-allowed;
    }
  </style>

</head>

<body class="sidebar-mini layout-fixed">
  <div class="wrapper">


    <div id="myModal" class="modal" tabindex="-1" role="dialog">
      <div class="modal-dialog" role="document">
        <div class="modal-content">
          <div class="modal-header">
            <h5 id="myModalLabel" class="modal-title"></h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <p id="myModalText"></p>
          </div>
          <div class="modal-footer">
            <button id="btnYes" type="button" class="btn btn-primary">Sim</button>
            <button id="btnNo" type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
          </div>
        </div>
      </div>
    </div>

    <div class="content-wrapper">
      <section class="content">
        <div class="container-fluid" id="grad1">
          <div class="row justify-content-center mt-0">
            <div class="col-10 text-center p-0 mt-3 mb-2">
              <div class="card px-0 pt-4 pb-0 mt-3 mb-3">
                <div class="card-header text-center flex" style="border: none!important;box-shadow:none!important;">
                  <h2>Orçamento
                    <button title="Tutorial" type="button" class="btn btn-info btn-sm ml-2" style="color: white;" id="tutorial">
                      <i class="fas fa-question-circle"></i>
                    </button>
                  </h2>
                </div>

                <div class="row">
                  <div class="col-md-12 mx-0">
                    <form id="msform">
                      <ul id="progressbar">
                        <li class="active" id="account"><strong>Geral</strong></li>
                        <li id="payment"><strong>Itens</strong></li>
                        <li id="personal"><strong>Financeiro</strong></li>
                        <li id="confirm"><strong>Transporte</strong></li>
                      </ul>
                      <p>Preencha os dados e clique em avançar até a conclusão do orçamento</p>
                      <fieldset>
                        <div class="form-card" id="tourGeral">
                          <h2 class="fs-title"> Dados Gerais </h2>
                          <div class="row">

                            <div class="col-lg-6 col-6 form-group">
                              <label data-error="wrong" data-success="right" for="txtNumero">Número</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" disabled id="txtNumero" name="txtNumero" class="form-control" placeholder="Número">
                              </div>
                            </div>

                            <div class="col-lg-6  col-12 form-group">
                              <label>Empresa</label>
                              <div class="input-group">
                                <select class="form-control select2 select2-danger focus" id="selectEmpresa" name="selectEmpresa" data-dropdown-css-class="select2-danger">
                                </select>
                              </div>
                            </div>

                            <div class="col-lg-6 col-6 form-group">
                              <label data-error="wrong" data-success="right" for="txtCliente">Cliente *</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtCliente" name="txtCliente" class="form-control" placeholder="Cliente">
                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btn-cliente" name="btn-cliente" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                  <button class="btn bg-danger" id="btn-limpa-cliente" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                  <button class="btn bg-danger" id="btn-adiciona-cliente" type="button" title="Incluir Cliente"><i class="m-0 p-0 fas fa-plus"></i></button>
                                </div>
                              </div>
                            </div>

                            <div class="col-lg-3 col-3 form-group">
                              <label data-error="wrong" data-success="right" for="txtPedcli">Ped. cli.</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtPedcli" name="txtPedcli" class="form-control" placeholder="Ped. Cli.">
                              </div>
                            </div>

                            <div class="col-lg-3  col-12 form-group">
                              <label data-error="wrong" data-success="right" for="dtDigitacao">Data digitação</label>
                              <div class="input-group">
                                <input type="date" max="2500-12-31" value="" class="input-default focus form-control" disabled id="dtDigitacao" name="dtDigitacao" class="form-control" placeholder="Comissão 1">
                              </div>
                            </div>

                            <div class="col-lg-6 col-6 form-group">
                              <label data-error="wrong" data-success="right" for="txtRepresentante">Representante</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtRepresentante" name="txtRepresentante" class="form-control" placeholder="Representante">
                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btn-Representante" name="btn-Representante" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                  <button class="btn bg-danger" id="btn-limpa-Representante" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                </div>
                              </div>
                            </div>

                            <div class="col-lg-3 col-3 form-group">
                              <label data-error="wrong" data-success="right" for="txtComissaoFat">% Comissão fat.</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtComissaoFat" name="txtComissaoFat" class="form-control" placeholder="% Comissão Fat.">
                              </div>
                            </div>

                            <div class="col-lg-3 col-3 form-group">
                              <label data-error="wrong" data-success="right" for="txtComissaoRec">% Comissão rec.</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtComissaoRec" name="txtComissaoRec" class="form-control" placeholder="% Comissão rec.">
                              </div>
                            </div>

                            <div class="col-lg-6 col-6 form-group">
                              <label data-error="wrong" data-success="right" for="txtAgencia">Agência</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtAgencia" name="txtAgencia" class="form-control" placeholder="Agência">
                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btn-Agencia" name="btn-Agencia" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                  <button class="btn bg-danger" id="btn-limpa-Agencia" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                </div>
                              </div>
                            </div>

                            <div class="col-lg-3 col-3 form-group">
                              <label data-error="wrong" data-success="right" for="txtComissao">% Comissão</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtComissao" name="txtComissao" class="form-control" placeholder="% Comissão">
                              </div>
                            </div>

                            <div class="col-lg-3 col-3 form-group">
                              <label data-error="wrong" data-success="right" for="txtPedido">Pedido</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtPedido" name="txtPedido" class="form-control" placeholder="Pedido">
                              </div>
                            </div>

                            <div class="col-lg-6 col-6 form-group">
                              <label data-error="wrong" data-success="right" for="txtSolicitante">Solicitante</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtSolicitante" name="txtSolicitante" class="form-control" placeholder="Solicitante">
                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btn-Solicitante" name="btn-Solicitante" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                  <button class="btn bg-danger" id="btn-limpa-Solicitante" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                </div>
                              </div>
                            </div>

                            <div class="col-lg-3 col-3 form-group">
                              <label data-error="wrong" data-success="right" for="txtTabPreco">Tabela de preço </label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtTabPreco" name="txtTabPreco" class="form-control" placeholder="Tabela de preço">
                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btn-TabPreco" name="btn-TabPreco" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                  <button class="btn bg-danger" id="btn-limpa-TabPreco" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                </div>
                              </div>
                            </div>

                            <div class="col-lg-3  col-12 form-group">
                              <label>Status comercial</label>
                              <div class="input-group">
                                <select class="form-control select2 select2-danger focus" id="selectStatusComercial" name="selectStatusComercial" data-dropdown-css-class="select2-danger">
                                  <option value="0">Bloqueado</option>
                                  <option value="1" selected>Liberado</option>
                                </select>
                              </div>
                            </div>

                            <div class="col-lg-2  col-12 form-group">
                              <label data-error="wrong" data-success="right" for="dtEmissao">Data emissão</label>
                              <div class="input-group">
                                <input type="date" max="2500-12-31" value="" class="input-default focus form-control" id="dtEmissao" disabled name="dtEmissao" class="form-control" placeholder="Comissão 1">
                              </div>
                            </div>

                            <div class="col-lg-2 col-2 form-group">
                              <label data-error="wrong" data-success="right" for="txtDiasValidade">Dias Validade</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtDiasValidade" name="txtDiasValidade" class="form-control" placeholder="Dias Validade">
                              </div>
                            </div>

                            <div class="col-lg-2  col-12 form-group">
                              <label data-error="wrong" data-success="right" for="dtValidade">Data validade</label>
                              <div class="input-group">
                                <input type="date" max="2500-12-31" value="" class="input-default focus form-control" id="dtValidade" name="dtValidade" class="form-control" placeholder="Comissão 1">
                              </div>
                            </div>


                            <div class="col-lg-2 col-2 form-group">
                              <label data-error="wrong" data-success="right" for="txtDias">Dias</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtDias" name="txtDias" class="form-control" placeholder="Dias">
                              </div>
                            </div>

                            <div class="col-lg-2  col-12 form-group">
                              <label data-error="wrong" data-success="right" for="dtEntrega">Data entrega</label>
                              <div class="input-group">
                                <input type="date" max="2500-12-31" value="" class="input-default focus form-control" id="dtEntrega" name="dtEntrega" class="form-control" placeholder="Comissão 1">
                              </div>
                            </div>

                            <div class="col-lg-2  col-12 form-group">
                              <label data-error="wrong" data-success="right" for="dtSaida">Data saída</label>
                              <div class="input-group">
                                <input type="date" max="2500-12-31" value="" class="input-default focus form-control" id="dtSaida" name="dtSaida" class="form-control" placeholder="Comissão 1">
                              </div>
                            </div>

                            <div class="col-lg-12  col-12 form-group">
                              <label data-error="wrong" data-success="right" for="txtObservacoes">Observações</label>
                              <textarea style="resize: none" id="txtObservacoes" placeholder="Observações" class="input-default focus form-control" rows="4"></textarea>
                            </div>

                            <div class="col-lg-6 col-md-12 col-sm-12">
                              <fieldset class="form border-Field p-0">
                                <legend class="textoBorda pb-0 mb-0">Situação</legend>
                                <div class="form-row" style="padding-left: 5%;">
                                  <div class="icheck-primary mr-3"><input type="radio" checked id="rdSituacaoAberto" name="radioSituacao" value="0"><label for="rdSituacaoAberto" class="labelCheck">Aberto</label></div>
                                  <div class="icheck-primary mr-3"><input type="radio" id="rdSituacaoFechado" name="radioSituacao" value="1"><label for="rdSituacaoFechado" class="labelCheck">Fechado</label></div>
                                  <div class="icheck-primary mr-3"><input type="radio" id="rdSituacaoEmAprov" name="radioSituacao" value="2"><label for="rdSituacaoEmAprov" class="labelCheck">Em aprovação</label></div>
                                  <div class="icheck-primary mr-3"><input type="radio" id="rdSituacaoPerdido" name="radioSituacao" value="3"><label for="rdSituacaoPerdido" class="labelCheck">Perdido</label></div>
                                </div>
                              </fieldset>
                            </div>

                            <div class="col-lg-6 col-md-12 col-sm-12">
                              <fieldset class="form border-Field p-0">
                                <legend class="textoBorda pb-0 mb-0">Somar dias a entrega</legend>
                                <div class="form-row" style="padding-left: 30%;">
                                  <div class="icheck-primary mr-3"><input type="radio" checked id="rdSumDiasCorridos" name="radioSumDias" value="0"><label for="rdSumDiasCorridos" class="labelCheck">Corridos</label></div>
                                  <div class="icheck-primary mr-3"><input type="radio" id="rdSumDiasUteis" name="radioSumDias" value="1"><label for="rdSumDiasUteis" class="labelCheck">Úteis</label></div>
                                </div>
                              </fieldset>
                            </div>

                            <div class="form-card" id="divTotais">
                              <hr>
                              <h2 class="fs-title" style="margin-top: 2%">Totais</h2>
                              <hr>
                              <div class="row card-totais">
                                <div class="col-sm-12 col-12">
                                  <div class="row d-flex justify-content-center">
                                    <div class="col-sm-3 col-6">
                                      <div class="description-block border-right">
                                        <h5 id="txtTotalQtde" class="description-header txtTotalQtde">0</h5>
                                        <span>Quantidade</span>
                                      </div>
                                    </div>
                                    <div class="col-sm-3 col-6">
                                      <div class="description-block border-right">
                                        <h5 id="txtTotalComissao" class="description-header txtTotalComissao"> 0,00</h5>
                                        <span>Valor Comissão</span>
                                      </div>
                                    </div>
                                    <div class="col-sm-3 col-6">
                                      <div class="description-block border-right">
                                        <h5 id="txtTotalLiquido" class="description-header txtTotalLiquido"> 0,00</h5>
                                        <span>Valor Líquido</span>
                                      </div>
                                    </div>
                                    <div class="col-sm-3 col-6">
                                      <div class="description-block">
                                        <h5 id="txtValorTotal" class="description-header txtValorTotal"> 0,00</h5>
                                        <span>Valor Total</span>
                                      </div>
                                    </div>
                                  </div>
                                </div>
                                <div class="col-sm-12 col-12">
                                  <div class="row d-flex justify-content-center">
                                    <div class="col-sm-3 col-6">
                                      <div class="description-block border-right">
                                        <h5 id="txtValorIpi" class="description-header txtValorIpi"> 0,00</h5>
                                        <span>Valor IPI</span>
                                      </div>
                                    </div>
                                    <div class="col-sm-3 col-6">
                                      <div class="description-block border-right">
                                        <h5 id="txtValorSubst" class="description-header txtValorSubst"> 0,00</h5>
                                        <span>Valor Subst.</span>
                                      </div>
                                    </div>
                                    <div class="col-sm-3 col-6">
                                      <div class="description-block border-right">
                                        <h5 id="txtValorConvertido" class="description-header txtValorConvertido"> 0,00</h5>
                                        <span>Valor Convertido</span>
                                      </div>
                                    </div>
                                    <div class="col-sm-3 col-6">
                                      <div class="description-block">
                                        <h5 id="txtValorLiqIpi" class="description-header txtValorLiqIpi"> 0,00</h5>
                                        <span>Valor Liq. + Ipi.</span>
                                      </div>
                                    </div>
                                  </div>
                                </div>
                              </div>
                              <hr>
                            </div>

                          </div>
                        </div>
                        <input type="button" id="avancar1" name="next" class="btn-sisp next action-button" value="Avançar" />
                        <button type="button" id="btnVoltar" name="previous" style="font-size:15px;" class="btn-sisp action-button-previous">Voltar</button>
                      </fieldset>
                      <fieldset>
                        <div class="form-card">

                          <div class="row d-flex justify-content-between">
                            <div class="col-lg-1">
                              <h2 class="fs-title">Itens</h2>
                            </div>
                            <div class="col-lg-2">
                              <button type="button" id="btnAddItem" class="btn btn-danger">Adicionar Item</button>
                            </div>
                          </div>

                          <hr>
                          <div id="items-wrap" class="table-wrap">
                            <div class="col-sm-12 table-responsive" style="margin-top: 2%;">
                              <table style="width:100%" class="table table-responsive-sm table-select table-hover" width="100%" id="tabelaItens">
                                <thead>
                                </thead>
                                <tbody>
                                </tbody>
                              </table>
                              <div id="tabelasInvisiveis" class="d-none">
                                <table style="width:100%" class="table table-responsive-sm table-select table-hover" width="100%" id="tabelaItensCaracteristica"></table>
                                <table style="width:100%" class="table table-responsive-sm table-select table-hover" width="100%" id="tabelaItensSerigrafia"></table>
                                <table style="width:100%" class="table table-responsive-sm table-select table-hover" width="100%" id="tabelaItensBordado"></table>
                                <table style="width:100%" class="table table-responsive-sm table-select table-hover" width="100%" id="tabelaItensDTF"></table>
                                <table style="width:100%" class="table table-responsive-sm table-select table-hover" width="100%" id="tabelaItensSublimacao"></table>
                                <table style="width:100%" class="table table-responsive-sm table-select table-hover" width="100%" id="tabelaItensTermotape"></table>
                                <table style="width:100%" class="table table-responsive-sm table-select table-hover" width="100%" id="tabelaItensConsumos"></table>
                              </div>
                            </div>
                          </div>

                          <h2 class="fs-title" style="margin-top: 2%">Totais</h2>
                          <hr>
                          <div class="row card-totais">
                            <div class="col-sm-12 col-12">
                              <div class="row d-flex justify-content-center">
                                <div class="col-sm-2 col-6">
                                  <div class="description-block border-right">
                                    <h5 id="txtTotalQtdeItens" class="description-header txtTotalQtde">0</h5>
                                    <span>Quantidade</span>
                                  </div>
                                </div>
                                <div class="col-sm-2 col-6">
                                  <div class="description-block border-right">
                                    <h5 id="txtTotalComissaoItens" class="description-header txtTotalComissao"> 0,00</h5>
                                    <span>Valor Comissão</span>
                                  </div>
                                </div>
                                <div class="col-sm-2 col-6">
                                  <div class="description-block border-right">
                                    <h5 id="txtTotalLiquidoItens" class="description-header txtTotalLiquido"> 0,00</h5>
                                    <span>Valor Líquido</span>
                                  </div>
                                </div>
                                <div class="col-sm-2 col-6">
                                  <div class="description-block">
                                    <h5 id="txtValorTotalItens" class="description-header txtValorTotal"> 0,00</h5>
                                    <span>Valor Total</span>
                                  </div>
                                </div>
                              </div>
                            </div>
                            <div class="col-sm-12 col-12">
                              <div class="row d-flex justify-content-center">
                                <div class="col-sm-2 col-6">
                                  <div class="description-block border-right">
                                    <h5 id="txtValorIpiItens" class="description-header txtValorIpi"> 0,00</h5>
                                    <span>Valor IPI</span>
                                  </div>
                                </div>
                                <div class="col-sm-2 col-6">
                                  <div class="description-block border-right">
                                    <h5 id="txtValorSubstItens" class="description-header txtValorSubst"> 0,00</h5>
                                    <span>Valor Subst.</span>
                                  </div>
                                </div>
                                <div class="col-sm-2 col-6">
                                  <div class="description-block border-right">
                                    <h5 id="txtValorConvertidoItens" class="description-header txtValorConvertido"> 0,00</h5>
                                    <span>Valor Convertido</span>
                                  </div>
                                </div>
                                <div class="col-sm-2 col-6">
                                  <div class="description-block">
                                    <h5 id="txtValorLiqIpiItens" class="description-header txtValorLiqIpi"> 0,00</h5>
                                    <span>Valor Liq. + Ipi.</span>
                                  </div>
                                </div>
                              </div>
                            </div>
                          </div>
                          <hr>
                        </div>

                        <input type="button" id="avancarItens" name="make_payment" class="btn-sisp next action-button" value="Avançar" />
                        <input type="button" name="previous" class="btn-sisp previous action-button-previous" value="Voltar" />

                      </fieldset>
                      <fieldset id="financeiroFs">
                        <div class="form-card">
                          <h2 class="fs-title">Dados Financeiros</h2>
                          <div class="row">
                            <div class="col-12">
                              <div class="row">
                                <div class="col-12 mb-3">
                                  <div class="row">
                                    <div class="col-lg-4 col-sm-3 form-group">
                                      <label data-error="wrong" data-success="right" for="txtCondicao">Condição: * </label>
                                      <div class="relative">
                                        <div class="input-group">
                                          <input type="text" class="input-default focus form-control" id="txtCondicao" name="txtCondicao" class="form-control" placeholder="Condição">
                                          <div class="input-group-append">
                                            <button class="btn bg-danger" id="btnCondicao" name="btnCondicao" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                            <button class="btn bg-danger" id="btnLimpaCondicao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                          </div>
                                        </div>
                                      </div>
                                    </div>

                                    <div class="col-8 d-flex p-0">
                                      <div class="col-lg-2 col-sm-2 form-group">
                                        <label data-error="wrong" data-success="right" for="txtPercEntrada">Perc. Ent.: </label>
                                        <div class="relative">
                                          <div class="input-group">
                                            <input type="text" class="input-default focus form-control dadosFinanHeader" disabled id="txtPercEntrada" name="txtPercEntrada" class="form-control" placeholder="Perc. Entrada">
                                          </div>
                                        </div>
                                      </div>

                                      <div class="col-lg-2 col-sm-2 form-group">
                                        <label data-error="wrong" data-success="right" for="txtPrzMedio">Prz. Médio: </label>
                                        <div class="relative">
                                          <div class="input-group">
                                            <input type="text" class="input-default focus form-control dadosFinanHeader" disabled id="txtPrzMedio" name="txtPrzMedio" class="form-control" placeholder="Prz. Médio">
                                          </div>
                                        </div>
                                      </div>

                                      <div class="col-lg-2 col-sm-2 form-group">
                                        <label data-error="wrong" data-success="right" for="txtMaxParcelas">Max. Parc.: </label>
                                        <div class="relative">
                                          <div class="input-group">
                                            <input type="text" class="input-default focus form-control dadosFinanHeader" disabled id="txtMaxParcelas" name="txtMaxParcelas" class="form-control" placeholder="Max. Parcelas">
                                          </div>
                                        </div>
                                      </div>

                                      <div class="col-lg-3 col-sm-3 form-group">
                                        <label data-error="wrong" data-success="right" for="txtPrzMaxPrimeira">Prz. Max 1ª Parc.: </label>
                                        <div class="relative">
                                          <div class="input-group">
                                            <input type="text" class="input-default focus form-control dadosFinanHeader" disabled id="txtPrzMaxPrimeira" name="txtPrzMaxPrimeira" class="form-control" placeholder="Prz. Max 1ª Parcela">
                                          </div>
                                        </div>
                                      </div>

                                      <div class="col-lg-3 col-sm-3 form-group">
                                        <label data-error="wrong" data-success="right" for="txtIntervaloParcelas">Intervalo Parc.: </label>
                                        <div class="relative">
                                          <div class="input-group">
                                            <input type="text" class="input-default focus form-control dadosFinanHeader" disabled id="txtIntervaloParcelas" name="txtIntervaloParcelas" class="form-control" placeholder="Intervalo Parcelas">
                                          </div>
                                        </div>
                                      </div>

                                    </div>


                                  </div>
                                </div>
                                <div class="col-6">
                                  <div class="row">

                                    <div class="col-lg-6 col-sm-3 form-group">
                                      <label data-error="wrong" data-success="right" for="txtValorEntrada">Valor Entrada: </label>
                                      <div class="relative">
                                        <div class="input-group">
                                          <input type="text" class="input-default focus form-control maskDecimais dadosFinan" disabled id="txtValorEntrada" name="txtValorEntrada" class="form-control" placeholder="Valor Entrada">
                                        </div>
                                      </div>
                                    </div>

                                    <div class="col-lg-6 col-sm-3 form-group">
                                    </div>

                                    <div class="col-lg-3 col-sm-3 form-group">
                                      <label data-error="wrong" data-success="right" for="txtNParcelas">Nº Parc.: </label>
                                      <div class="relative">
                                        <div class="input-group">
                                          <input type="text" class="input-default focus form-control maskInteiro dadosFinan blurEnter" disabled id="txtNParcelas" name="txtNParcelas" class="form-control" placeholder="Nº Parcelas">
                                        </div>
                                      </div>
                                    </div>

                                    <div class="col-lg-3 col-sm-3 form-group">
                                      <label data-error="wrong" data-success="right" for="txtPrazoPrimeiraParc">Prz. 1ª Parc.: </label>
                                      <div class="relative">
                                        <div class="input-group">
                                          <input type="text" class="input-default focus form-control maskInteiro dadosFinan blurEnter" disabled id="txtPrazoPrimeiraParc" name="txtPrazoPrimeiraParc" class="form-control" placeholder="Prazo 1ª Parcela">
                                        </div>
                                      </div>
                                    </div>

                                    <div class="col-lg-3 col-sm-3 form-group">
                                      <label data-error="wrong" data-success="right" for="txtIntervaloParc">Inter. Parc.: </label>
                                      <div class="relative">
                                        <div class="input-group">
                                          <input type="text" class="input-default focus form-control maskInteiro dadosFinan blurEnter" disabled id="txtIntervaloParc" name="txtIntervaloParc" class="form-control" placeholder="Intervalo Parc.">
                                        </div>
                                      </div>
                                    </div>

                                    <div class="col-lg-3 col-sm-3 form-group">
                                      <label data-error="wrong" data-success="right" for="txtPrazoMedioCalc">Prz. Médio: </label>
                                      <div class="relative">
                                        <div class="input-group">
                                          <input type="text" class="input-default focus form-control maskInteiro" disabled disabled id="txtPrazoMedioCalc" name="txtPrazoMedioCalc" class="form-control" placeholder="Prazo Médio Calc.">
                                        </div>
                                      </div>
                                    </div>

                                    <div class="col-lg-12  col-12 form-group" style="margin-bottom: 0px;">
                                      <label data-error="wrong" data-success="right">Desconto:</label>
                                    </div>
                                    <div class="col-lg-2  col-2 form-group">
                                      <div class="input-group">
                                        <input type="text" class="input-default focus form-control maskDecimais dadosFinan" disabled id="txtDesconto1" name="txtDesconto1" placeholder="1">
                                      </div>
                                    </div>
                                    <div class="col-lg-2  col-2 form-group">
                                      <div class="input-group">
                                        <input type="text" class="input-default focus form-control maskDecimais dadosFinan" disabled id="txtDesconto2" name="txtDesconto2" placeholder="2">
                                      </div>
                                    </div>
                                    <div class="col-lg-2  col-2 form-group">
                                      <div class="input-group">
                                        <input type="text" class="input-default focus form-control maskDecimais dadosFinan" disabled id="txtDesconto3" name="txtDesconto3" placeholder="3">
                                      </div>
                                    </div>
                                    <div class="col-lg-2  col-2 form-group">
                                      <div class="input-group">
                                        <input type="text" class="input-default focus form-control maskDecimais dadosFinan" disabled id="txtDesconto4" name="txtDesconto4" placeholder="4">
                                      </div>
                                    </div>
                                    <div class="col-lg-2  col-2 form-group">
                                      <div class="input-group">
                                        <input type="text" class="input-default focus form-control maskDecimais dadosFinan" disabled id="txtDesconto5" name="txtDesconto5" placeholder="5">
                                      </div>
                                    </div>
                                    <div class="col-lg-2  col-2 form-group">
                                      <div class="input-group">
                                        <input type="text" class="input-default focus form-control maskDecimais" disabled id="txtDesconto" name="txtDesconto" placeholder="Desconto">
                                      </div>
                                    </div>

                                    <div class="col-lg-12 col-sm-12 form-group d-flex justify-content-between pt-2">
                                      <div class="icheck-primary">
                                        <input class="ml-2" type="checkbox" checked id="checkConsiderarSimulação">
                                        <label for="checkConsiderarSimulação">Considerar simulação financeira</label>
                                      </div>

                                      <button type="button" id="btnGerarParcelas" class="btn btn-primary">Gerar Parcelas</button>
                                    </div>

                                  </div>
                                </div>
                                <!-- <span id="txtValorNota" class="d-none"></span> -->
                                <div class="col-lg-6">
                                  <div class="row">

                                    <div class="col-lg-12 table-responsive">
                                      <!-- <label data-error="wrong" data-success="right" for="tabelaDuplicatas">Financeiro</label> -->
                                      <table id="tabelaDuplicatas" class="display table table-sm" width="100%" style="width:100%">
                                        <thead>
                                          <tr>
                                            <th>Parcela</th>
                                            <th>Vencimento</th>
                                            <th>Valor</th>
                                          </tr>
                                        </thead>
                                        <tbody>
                                        </tbody>
                                      </table>
                                    </div>

                                    <div class="col-lg-12" style="margin-left: .7%;">
                                      <div class="info-box row" style="background-color: var(--blue-color)!important">
                                        <span class="info-box-icon"><i class="fas fa-dollar-sign text-white"></i></span>
                                        <div class="info-box-content">
                                          <span class="info-box-text text-white" style="font-size:15px">VALOR
                                            TOTAL</span>
                                          <span id="txtValorFinanceiro" class="info-box-number text-white" style="font-size:20px">&nbsp;0,00</span>
                                        </div>
                                      </div>
                                    </div>
                                  </div>
                                </div>

                                <div class="col-lg-6 col-sm-12 form-group">
                                  <label data-error="wrong" data-success="right" for="txtMoeda">Moeda: *</label>
                                  <div class="input-group">
                                    <input type="text" class="input-default focus form-control" id="txtMoeda" name="txtMoeda" class="form-control" placeholder="Moeda">
                                    <div class="input-group-append">
                                      <button class="btn bg-danger" id="btnMoeda" name="btnMoeda" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                      <button class="btn bg-danger" id="btnAMoeda" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                    </div>
                                  </div>
                                </div>
                                <div class="col-lg-6 col-sm-12 form-group">
                                  <label data-error="wrong" data-success="right" for="txtHistorico">Histórico: *</label>
                                  <div class="input-group">
                                    <input type="text" class="input-default focus form-control" id="txtHistorico" name="txtHistorico" class="form-control" placeholder="Histórico">
                                    <div class="input-group-append">
                                      <button class="btn bg-danger" id="btn-historico" name="btn-historico" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                      <button class="btn bg-danger" id="btn-limpa-historico" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                    </div>
                                  </div>
                                </div>
                                <div class="col-lg-6 col-sm-12 form-group">
                                  <label data-error="wrong" data-success="right" for="txtSituacao">Situação: *</label>
                                  <div class="input-group">
                                    <input type="text" class="input-default focus form-control" id="txtSituacao" name="txtSituacao" class="form-control" placeholder="Situação">
                                    <div class="input-group-append">
                                      <button class="btn bg-danger" id="btn-situacao" name="btn-situacao" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                      <button class="btn bg-danger" id="btn-limpa-situacao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                    </div>
                                  </div>
                                </div>
                                <div class="col-lg-6 col-sm-12 form-group">
                                  <label data-error="wrong" data-success="right" for="txtClasseGer">Classe Gerencial: *</label>
                                  <div class="input-group">
                                    <input type="text" class="input-default focus form-control" id="txtClasseGer" name="txtClasseGer" class="form-control" placeholder="Classe Gerencial">
                                    <div class="input-group-append">
                                      <button class="btn bg-danger" id="btn-classeGer" name="btn-classeGer" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                      <button class="btn bg-danger" id="btn-limpa-classeGer" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                    </div>
                                  </div>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                        <input type="button" id="avancarFinanceiro" name="next" class="btn-sisp next action-button" value="Avançar" />
                        <input type="button" name="previous" id="voltarFinanceiro" class="btn-sisp previous action-button-previous" value="Voltar" />
                      </fieldset>
                      <fieldset>
                        <div class="form-card">
                          <h2 class="fs-title">Transporte</h2> <br><br>

                          <div class="row">
                            <div class="col-12">
                              <div class="row">

                                <div class="col-lg-6 col-sm-12 form-group">
                                  <label data-error="wrong" data-success="right" for="txtTransportadora">Transportadora</label>
                                  <div class="input-group">
                                    <input type="text" class="input-default focus form-control" id="txtTransportadora" name="txtTransportadora" class="form-control" placeholder="Transportadora">
                                    <div class="input-group-append">
                                      <button class="btn bg-danger" id="btnTransportadora" name="btnTransportadora" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                      <button class="btn bg-danger" id="btnATransportadora" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                    </div>
                                  </div>
                                </div>

                                <div class="col-lg-6 col-12 m-6 form-group">
                                  <label data-error="wrong" data-success="right" for="txtTransportador">Frete por conta</label>
                                  <select style="width:100%;" class="form-control select2 select2-danger focus" data-dropdown-css-class="select2-danger" id="rgTransportador" class="custom-select focus">
                                    <option value="">Selecione uma opção</option>
                                    <option value="0">0 - Contratação do Frete por conta do Remetente (CIF)</option>
                                    <option value="1">1 - Contratação do Frete por conta do Destinatário (FOB)</option>
                                    <option value="2">2 - Contratação do Frete por conta de Terceiros</option>
                                    <option value="3">3 - Transporte Próprio por conta do Remetente</option>
                                    <option value="4">4 - Transporte Próprio por conta do Destinatário</option>
                                    <option value="8">8 - Por Conta do Destinatário na NF</option>
                                    <option selected value="9">9 - Sem Ocorrência de Transporte</option>
                                  </select>
                                </div>

                                <div class="col-lg-6  col-12 form-group">
                                  <label data-error="wrong" data-success="right" for="txtNatureza">Natureza</label>
                                  <div class="input-group">
                                    <input type="text" class="input-default focus form-control" id="txtNatureza" name="txtNatureza" class="form-control" placeholder="Natureza">
                                    <div class="input-group-append">
                                      <button class="btn bg-danger" id="btn-natureza" name="btn-natureza" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                      <button class="btn bg-danger" id="btn-limpa-natureza" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                    </div>
                                  </div>
                                </div>

                                <div class="col-lg-6  col-12 form-group">
                                  <label data-error="wrong" data-success="right" for="txtAliquota">Alíquota</label>
                                  <div class="input-group">
                                    <input type="text" class="input-default focus form-control" disabled id="txtAliquota" name="txtAliquota" class="form-control" placeholder="Alíquota">
                                  </div>
                                </div>

                                <div class="col-lg-3  col-12 form-group">
                                  <label data-error="wrong" data-success="right" for="txtValFrete">Valor frete</label>
                                  <div class="input-group">
                                    <input type="text" class="input-default focus form-control" id="txtValFrete" name="txtValFrete" class="form-control" placeholder="Valor frete">
                                  </div>
                                </div>

                                <div class="col-lg-3  col-12 form-group">
                                  <label data-error="wrong" data-success="right" for="txtPesoBruto">Peso bruto</label>
                                  <div class="input-group">
                                    <input type="text" class="input-default focus form-control" id="txtPesoBruto" name="txtPesoBruto" class="form-control" placeholder="Peso bruto">
                                  </div>
                                </div>

                                <div class="col-lg-3  col-12 form-group">
                                  <label data-error="wrong" data-success="right" for="txtPesoLiquido">Peso líquido</label>
                                  <div class="input-group">
                                    <input type="text" class="input-default focus form-control" id="txtPesoLiquido" name="txtPesoLiquido" class="form-control" placeholder="Peso líquido">
                                  </div>
                                </div>

                                <div class="col-lg-3  col-12 form-group">
                                  <label data-error="wrong" data-success="right" for="txtVolumes">Volumes</label>
                                  <div class="input-group">
                                    <input type="text" class="input-default focus form-control" id="txtVolumes" name="txtVolumes" class="form-control" placeholder="Volumes">
                                  </div>
                                </div>

                                <div class="col-lg-6  col-12 form-group">
                                  <label data-error="wrong" data-success="right" for="txtEndEntrega">Endereço entrega</label>
                                  <div class="input-group">
                                    <input type="text" class="input-default focus form-control" disabled id="txtEndEntrega" name="txtEndEntrega" class="form-control" placeholder="Endereço entrega">
                                  </div>
                                </div>

                                <div class="col-lg-6  col-12 form-group">
                                  <label data-error="wrong" data-success="right" for="txtBairroEntrega">Bairro entrega</label>
                                  <div class="input-group">
                                    <input type="text" class="input-default focus form-control" disabled id="txtBairroEntrega" name="txtBairroEntrega" class="form-control" placeholder="Bairro entrega">
                                  </div>
                                </div>

                                <div class="col-lg-3  col-12 form-group">
                                  <label data-error="wrong" data-success="right" for="txtCidadeEntrega">Cidade entrega</label>
                                  <div class="input-group">
                                    <input type="text" class="input-default focus form-control" disabled id="txtCidadeEntrega" name="txtCidadeEntrega" class="form-control" placeholder="Cidade entrega">
                                  </div>
                                </div>

                                <div class="col-lg-3  col-12 form-group">
                                  <label data-error="wrong" data-success="right" for="txtEstadoEntrega">Estado entrega</label>
                                  <div class="input-group">
                                    <input type="text" class="input-default focus form-control" disabled id="txtEstadoEntrega" name="txtEstadoEntrega" class="form-control" placeholder="Estado entrega">
                                  </div>
                                </div>

                                <div class="col-lg-3  col-12 form-group">
                                  <label data-error="wrong" data-success="right" for="txtNumeroEntrega">Número entrega</label>
                                  <div class="input-group">
                                    <input type="text" class="input-default focus form-control" disabled id="txtNumeroEntrega" name="txtNumeroEntrega" class="form-control" placeholder="Número entrega">
                                  </div>
                                </div>

                                <div class="col-lg-3  col-12 form-group">
                                  <label data-error="wrong" data-success="right" for="txtCepEntrega">CEP entrega</label>
                                  <div class="input-group">
                                    <input type="text" class="input-default focus form-control" disabled id="txtCepEntrega" name="txtCepEntrega" class="form-control" placeholder="CEP entrega">
                                  </div>
                                </div>

                              </div>
                            </div>
                          </div>
                        </div>

                        <input type="button" id="gravar" class="btn-sisp action-button" value="Gravar" />
                        <input type="button" name="previous" id="ultimoVoltar" class="btn-sisp previous action-button-previous" value="Voltar" />
                      </fieldset>
                    </form>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>
    </div>
  </div>

  <div class="modal fade" id="modalItem" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog " style="min-width: 95%;">
      <div class="modal-content">
        <div class="modal-header">
          <h4 class="modal-title">Adicionar Item</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">

          <div class="row">

            <div class="col-lg-6  col-12 form-group">
              <label data-error="wrong" data-success="right" for="txtCodigo">Código</label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control" id="txtCodigo" name="txtCodigo" class="form-control" placeholder="Código">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btn-Codigo" name="btn-Codigo" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btn-limpa-Codigo" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>

            <div class="col-lg-3  col-12 form-group">
              <label data-error="wrong" data-success="right" for="txtCor">Cor</label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control" id="txtCor" name="txtCor" class="form-control" placeholder="Cor">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btn-Cor" name="btn-Cor" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btn-limpa-Cor" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>

            <div class="col-lg-3  col-12 form-group">
              <label data-error="wrong" data-success="right" for="txtLinha">Linha</label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control camposNormal" id="txtLinha" name="txtLinha" class="form-control" placeholder="Linha">
                <div class="input-group-append">
                  <button class="btn bg-danger camposNormal" id="btn-Linha" name="btn-Linha" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger camposNormal" id="btn-limpa-Linha" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>

            <div class="col-lg-3  col-12 form-group">
              <label data-error="wrong" data-success="right" for="txtGrupo">Grupo</label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control camposNormal" id="txtGrupo" name="txtGrupo" class="form-control" placeholder="Grupo">
                <div class="input-group-append">
                  <button class="btn bg-danger camposNormal" id="btn-Grupo" name="btn-Grupo" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger camposNormal" id="btn-limpa-Grupo" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>

            <div class="col-lg-3  col-12 form-group">
              <label data-error="wrong" data-success="right" for="txtEtiqueta">Etiqueta</label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control camposNormal" id="txtEtiqueta" name="txtEtiqueta" class="form-control" placeholder="Etiqueta">
                <div class="input-group-append">
                  <button class="btn bg-danger camposNormal" id="btn-Etiqueta" name="btn-Etiqueta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger camposNormal" id="btn-limpa-Etiqueta" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>

            <div class="col-lg-3  col-12 form-group">
              <label data-error="wrong" data-success="right" for="txtMarkup">Markup </label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control" id="txtMarkup" name="txtMarkup" class="form-control" placeholder="Markup">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btn-Markup" name="btn-Markup" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btn-limpa-Markup" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>

            <div class="col-lg-3  col-12 form-group">
              <label data-error="wrong" data-success="right" for="txtDeposito">Depósito</label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control" id="txtDeposito" name="txtDeposito" class="form-control" placeholder="Depósito">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btn-Deposito" name="btn-Deposito" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btn-limpa-Deposito" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>

            <div class="col-lg-3  col-12 form-group">
              <label data-error="wrong" data-success="right" for="txtFrete">Frete</label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control" id="txtFrete" name="txtFrete" class="form-control" placeholder="Frete">
              </div>
            </div>

            <div class="col-lg-3  col-12 form-group">
              <label data-error="wrong" data-success="right" for="dtEntregaItem">Data entrega</label>
              <div class="input-group">
                <input type="date" max="2500-12-31" value="" class="input-default focus form-control" id="dtEntregaItem" name="dtEntregaItem" class="form-control" placeholder="Comissão 1">
              </div>
            </div>

            <div class="col-lg-3  col-12 form-group">
              <label data-error="wrong" data-success="right" for="txtComplDescProd">Compl. Desc. Produto</label>
              <div class="input-group">
                <input type="text" maxlength="40" class="input-default focus form-control" disabled id="txtComplDescProd" name="txtComplDescProd" class="form-control" placeholder="Compl. Desc. Produto">
              </div>
            </div>

          </div>

          <hr>

          <nav>
            <div class="nav nav-tabs justify-content-center" id="nav-tab" role="tablist" style="text-decoration: none">
              <a class="nav-link abaLink active" id="tabCaracteristicas" data-toggle="tab" href="#divCaracteristicas" role="tab" aria-controls="divCaracteristicas" aria-selected="true">Características</a>
              <a class="nav-link abaLink" id="tabComposicao" data-toggle="tab" href="#divComposicao" role="tab" aria-controls="divComposicao" aria-selected="false">Composição</a>
              <a class="nav-link abaLink" id="tabAplicacoes" data-toggle="tab" href="#divAplicacoes" role="tab" aria-controls="divAplicacoes" aria-selected="false">Aplicações</a>
              <a class="nav-link abaLink" id="tabConsumos" data-toggle="tab" href="#divConsumos" role="tab" aria-controls="divConsumos" aria-selected="false">Consumos/Ficha técnica</a>
              <a class="nav-link abaLink" id="tabCustomizacoes" data-toggle="tab" href="#divCustomizacoes" role="tab" aria-controls="divCustomizacoes" aria-selected="false">Customizações</a>
              <a class="nav-link abaLink" id="tabGrade" data-toggle="tab" href="#divGrade" role="tab" aria-controls="divGrade" aria-selected="false">Grade</a>
              <a class="nav-link abaLink" id="tabObs" data-toggle="tab" href="#divObs" role="tab" aria-controls="divObs" aria-selected="false">Observações</a>
              <a class="nav-link abaLink d-none" id="tabFt" data-toggle="tab" href="#divFt" role="tab" aria-controls="divFt" aria-selected="false">Ficha técnica</a>
            </div>
          </nav>
          <div class="tab-content" id="nav-tabContent">

            <!-- caracteristicas -->
            <div class="tab-pane fade show active" id="divCaracteristicas" role="tabpanel" aria-labelledby="tabCaracteristicas">
              <div class="row" style="margin-top: 15px;">

                <div class="col-lg-12 form-group">
                  <table id="tabelaCaracteristicas" class="display table table-sm" width="100%" style="width:100%">
                  </table>
                </div>

              </div>
            </div>

            <!-- composições -->
            <div class="tab-pane fade" id="divComposicao" role="tabpanel" aria-labelledby="tabComposicao">
              <div class="row" style="margin-top: 15px;">

                <div class="col-lg-12 d-flex justify-content-end">
                  <button id="btnBuscarComposicao" class="btn btn-primary mr-2" title="Buscar Composição das Características">Buscar das Características</button>
                  <button id="btnAddComposicao" class="btn btn-danger">Adicionar Composição</button>
                </div>

                <div class="col-lg-12 form-group">
                  <table id="tabelaComposicao" class="display table table-sm" width="100%" style="width:100%">
                  </table>
                </div>

              </div>
            </div>

            <!-- aplicações -->
            <div class="tab-pane fade" id="divAplicacoes" role="tabpanel" aria-labelledby="tabAplicacoes">
              <div class="row" style="margin-top: 15px;">

                <div class="col-lg-4 form-group">
                  <label data-error="wrong" data-success="right" for="tabelaAplicacoes">Aplicações</label>
                  <table id="tabelaAplicacoes" class="display table table-sm" width="100%" style="width:100%">
                  </table>
                </div>

                <div class="col-lg-8 form-group">
                  <label data-error="wrong" data-success="right" for="tabelaTecidosUtilizados">Tecidos Utilizados</label>
                  <table id="tabelaTecidosUtilizados" class="display table table-sm" width="100%" style="width:100%">
                  </table>
                </div>

              </div>
            </div>

            <!-- consumos -->
            <div class="tab-pane fade" id="divConsumos" role="tabpanel" aria-labelledby="tabConsumos">
              <div class="row" style="margin-top: 15px;">

                <div class="col-lg-12 d-flex justify-content-end">
                  <button id="btnAddConsumo" class="btn btn-danger">Adicionar Consumo</button>
                </div>

                <div class="col-lg-12 form-group">
                  <table id="tabelaConsumos" class="display table table-sm" width="100%" style="width:100%">
                  </table>
                </div>

              </div>
            </div>

            <!-- customizações -->
            <div class="tab-pane fade" id="divCustomizacoes" role="tabpanel" aria-labelledby="tabCustomizacoes">

              <nav style="margin-top: 15px;">
                <div class="nav nav-tabs justify-content-center" id="nav-tab" role="tablist" style="text-decoration: none">
                  <a class="nav-link abaLink" id="tabSerigrafia" data-toggle="tab" href="#divSerigrafia" role="tab" aria-controls="divSerigrafia" aria-selected="false">Serigrafia</a>
                  <a class="nav-link abaLink" id="tabBordado" data-toggle="tab" href="#divBordado" role="tab" aria-controls="divBordado" aria-selected="false">Bordado</a>
                  <a class="nav-link abaLink" id="tabSublimacao" data-toggle="tab" href="#divSublimacao" role="tab" aria-controls="divSublimacao" aria-selected="false">Sublimação</a>
                  <a class="nav-link abaLink" id="tabTermotape" data-toggle="tab" href="#divTermotape" role="tab" aria-controls="divTermotape" aria-selected="false">Termotape</a>
                  <a class="nav-link abaLink" id="tabDTF" data-toggle="tab" href="#divDTF" role="tab" aria-controls="divDTF" aria-selected="false">DTF</a>
                </div>
              </nav>
              <div class="tab-content" id="nav-tabContent">

                <div class="tab-pane fade" id="divSerigrafia" role="tabpanel" aria-labelledby="tabSerigrafia">
                  <div class="row" style="margin-top: 15px;">

                    <div class="col-lg-6 form-group border-Field">
                      <div class="row d-flex justify-content-center">
                        <div class="col-lg-4 form-group">
                          <label style="margin-top: 17px" data-error="wrong" data-success="right" for="tabelaSerigrafiaTipo">Tipo</label>
                          <table id="tabelaSerigrafiaTipo" class="display table table-sm" width="100%" style="width:100%">
                          </table>
                        </div>

                        <div class="col-lg-4 form-group">
                          <label style="margin-top: 17px" data-error="wrong" data-success="right" for="tabelaSerigrafiaLocal">Local</label>
                          <table id="tabelaSerigrafiaLocal" class="display table table-sm" width="100%" style="width:100%">
                          </table>
                        </div>

                        <div class="col-lg-4 form-group">
                          <label style="margin-top: 17px" data-error="wrong" data-success="right" for="tabelaSerigrafiaTamanho">Tamanho</label>
                          <table id="tabelaSerigrafiaTamanho" class="display table table-sm" width="100%" style="width:100%">
                          </table>
                        </div>

                        <div class="col-lg-8  col-12 form-group">
                          <label data-error="wrong" data-success="right" for="txtNomeSerigrafia">Nome</label>
                          <div class="input-group">
                            <input type="text" class="input-default focus form-control" id="txtNomeSerigrafia" name="txtNomeSerigrafia" class="form-control" placeholder="Nome">
                          </div>
                        </div>

                        <div class="col-lg-3  col-12 form-group">
                          <label data-error="wrong" data-success="right" for="txtQtdeCores">Qtde Cores</label>
                          <div class="input-group">
                            <input type="text" class="input-default focus form-control" id="txtQtdeCores" name="txtQtdeCores" class="form-control" placeholder="Qtde Cores">
                          </div>
                        </div>

                        <div class="col-lg-3  col-12 form-group">
                          <label data-error="wrong" data-success="right" for="txtAlturaSerigrafia">Altura</label>
                          <div class="input-group">
                            <input type="text" class="input-default focus form-control" id="txtAlturaSerigrafia" name="txtAlturaSerigrafia" class="form-control" placeholder="Altura">
                          </div>
                        </div>

                        <div class="col-lg-3  col-12 form-group">
                          <label data-error="wrong" data-success="right" for="txtLarguraSerigrafia">Largura</label>
                          <div class="input-group">
                            <input type="text" class="input-default focus form-control" id="txtLarguraSerigrafia" name="txtLarguraSerigrafia" class="form-control" placeholder="Largura">
                          </div>
                        </div>

                        <div class="col-lg-3  col-12 form-group">
                          <label data-error="wrong" data-success="right" for="txtTotalPecasSerigrafia">Total Peças</label>
                          <div class="input-group">
                            <input type="text" class="input-default focus form-control" id="txtTotalPecasSerigrafia" name="txtTotalPecasSerigrafia" class="form-control" placeholder="Total Peças">
                          </div>
                        </div>

                        <div class="col-lg-1  col-12 form-group">
                          <button id="btnRemoveSerigrafia" class="btn btn-danger" style="margin-top: 28px"> « </button>
                        </div>

                        <div class="col-lg-1  col-12 form-group">
                          <button id="btnAddSerigrafia" class="btn btn-danger" style="margin-top: 28px"> » </button>
                        </div>

                      </div>
                    </div>


                    <div class="col-lg-6 form-group border-Field">
                      <label style="margin-top: 17px" data-error="wrong" data-success="right" for="tabelaSerigrafia">Serigrafia</label>
                      <table id="tabelaSerigrafia" class="display table table-sm" width="100%" style="width:100%">
                      </table>
                    </div>

                  </div>
                </div>

                <div class="tab-pane fade" id="divBordado" role="tabpanel" aria-labelledby="tabBordado">
                  <div class="row" style="margin-top: 15px;">

                    <div class="col-lg-6 form-group border-Field">
                      <div class="row d-flex justify-content-center">
                        <div class="col-lg-4 form-group">
                          <label style="margin-top: 17px" data-error="wrong" data-success="right" for="tabelaBordadoProgramacao">Programação</label>
                          <table id="tabelaBordadoProgramacao" class="display table table-sm" width="100%" style="width:100%">
                          </table>
                        </div>

                        <div class="col-lg-4 form-group">
                          <label style="margin-top: 17px" data-error="wrong" data-success="right" for="tabelaBordadoTamanho">Tamanho</label>
                          <table id="tabelaBordadoTamanho" class="display table table-sm" width="100%" style="width:100%">
                          </table>
                        </div>

                        <div class="col-lg-4 form-group">
                          <label style="margin-top: 17px" data-error="wrong" data-success="right" for="tabelaBordadoLocal">Local</label>
                          <table id="tabelaBordadoLocal" class="display table table-sm" width="100%" style="width:100%">
                          </table>
                        </div>

                        <div class="col-lg-8  col-12 form-group">
                          <label data-error="wrong" data-success="right" for="txtNomeBordado">Nome</label>
                          <div class="input-group">
                            <input type="text" class="input-default focus form-control" id="txtNomeBordado" name="txtNomeBordado" class="form-control" placeholder="Nome">
                          </div>
                        </div>

                        <div class="col-lg-3  col-12 form-group">
                          <label data-error="wrong" data-success="right" for="txtQtdeProg">Qtde Prog</label>
                          <div class="input-group">
                            <input type="text" class="input-default focus form-control" id="txtQtdeProg" name="txtQtdeProg" class="form-control" placeholder="Qtde Prog">
                          </div>
                        </div>

                        <div class="col-lg-3  col-12 form-group">
                          <label data-error="wrong" data-success="right" for="txtAlturaBordado">Altura</label>
                          <div class="input-group">
                            <input type="text" class="input-default focus form-control" id="txtAlturaBordado" name="txtAlturaBordado" class="form-control" placeholder="Altura">
                          </div>
                        </div>

                        <div class="col-lg-3  col-12 form-group">
                          <label data-error="wrong" data-success="right" for="txtLarguraBordado">Largura</label>
                          <div class="input-group">
                            <input type="text" class="input-default focus form-control" id="txtLarguraBordado" name="txtLarguraBordado" class="form-control" placeholder="Largura">
                          </div>
                        </div>

                        <div class="col-lg-3  col-12 form-group">
                          <label data-error="wrong" data-success="right" for="txtTotalPecasBordado">Total Peças</label>
                          <div class="input-group">
                            <input type="text" class="input-default focus form-control" id="txtTotalPecasBordado" name="txtTotalPecasBordado" class="form-control" placeholder="Total Peças">
                          </div>
                        </div>

                        <div class="col-lg-1  col-12 form-group">
                          <button id="btnRemoveBordado" class="btn btn-danger" style="margin-top: 28px"> « </button>
                        </div>

                        <div class="col-lg-1  col-12 form-group">
                          <button id="btnAddBordado" class="btn btn-danger" style="margin-top: 28px"> » </button>
                        </div>

                      </div>
                    </div>


                    <div class="col-lg-6 form-group border-Field">
                      <label style="margin-top: 17px" data-error="wrong" data-success="right" for="tabelaBordado">Bordado</label>
                      <table id="tabelaBordado" class="display table table-sm" width="100%" style="width:100%">
                      </table>
                    </div>

                  </div>
                </div>

                <div class="tab-pane fade" id="divSublimacao" role="tabpanel" aria-labelledby="tabSublimacao">
                  <div class="row" style="margin-top: 15px;">

                    <div class="col-lg-12 form-group">
                      <table id="tabelaSublimacao" class="display table table-sm" width="100%" style="width:100%">
                      </table>
                    </div>

                  </div>
                </div>

                <div class="tab-pane fade" id="divTermotape" role="tabpanel" aria-labelledby="tabTermotape">
                  <div class="row" style="margin-top: 15px;">

                    <div class="col-lg-6 form-group border-Field">
                      <div class="row d-flex justify-content-center">
                        <div class="col-lg-12 form-group">
                          <label style="margin-top: 17px" data-error="wrong" data-success="right" for="tabelaTermotapeTipo">Tipo</label>
                          <table id="tabelaTermotapeTipo" class="display table table-sm" width="100%" style="width:100%">
                          </table>
                        </div>

                        <div class="col-lg-5  col-12 form-group">
                        </div>

                        <div class="col-lg-3  col-12 form-group">
                          <label data-error="wrong" data-success="right" for="txtTamCm2">Tamanho (CM²)</label>
                          <div class="input-group">
                            <input type="text" class="input-default focus form-control" id="txtTamCm2" name="txtTamCm2" class="form-control" placeholder="Tamanho (CM²)">
                          </div>
                        </div>

                        <div class="col-lg-2  col-12 form-group">
                        </div>

                        <div class="col-lg-5  col-12 form-group">
                        </div>

                        <div class="col-lg-3  col-12 form-group">
                          <label data-error="wrong" data-success="right" for="txtTotalPecasTermotape">Total Peças</label>
                          <div class="input-group">
                            <input type="text" class="input-default focus form-control" id="txtTotalPecasTermotape" name="txtTotalPecasTermotape" class="form-control" placeholder="Total Peças">
                          </div>
                        </div>

                        <div class="col-lg-1  col-12 form-group">
                          <button id="btnRemoveTermotape" class="btn btn-danger" style="margin-top: 28px"> « </button>
                        </div>

                        <div class="col-lg-1  col-12 form-group">
                          <button id="btnAddTermotape" class="btn btn-danger" style="margin-top: 28px"> » </button>
                        </div>

                      </div>
                    </div>


                    <div class="col-lg-6 form-group border-Field">
                      <label style="margin-top: 17px" data-error="wrong" data-success="right" for="tabelaTermotape">Termotape</label>
                      <table id="tabelaTermotape" class="display table table-sm" width="100%" style="width:100%">
                      </table>
                    </div>

                  </div>
                </div>

                <div class="tab-pane fade" id="divDTF" role="tabpanel" aria-labelledby="tabDTF">
                  <div class="row" style="margin-top: 15px;">

                    <div class="col-lg-6 form-group border-Field">
                      <div class="row d-flex justify-content-center">
                        <div class="col-lg-4 form-group">
                          <label style="margin-top: 17px" data-error="wrong" data-success="right" for="tabelaDTFProgramacao">Programação</label>
                          <table id="tabelaDTFProgramacao" class="display table table-sm" width="100%" style="width:100%">
                          </table>
                        </div>

                        <div class="col-lg-4 form-group">
                          <label style="margin-top: 17px" data-error="wrong" data-success="right" for="tabelaDTFTamanho">Tamanho</label>
                          <table id="tabelaDTFTamanho" class="display table table-sm" width="100%" style="width:100%">
                          </table>
                        </div>

                        <div class="col-lg-4 form-group">
                          <label style="margin-top: 17px" data-error="wrong" data-success="right" for="tabelaDTFLocal">Local</label>
                          <table id="tabelaDTFLocal" class="display table table-sm" width="100%" style="width:100%">
                          </table>
                        </div>

                        <div class="col-lg-8  col-12 form-group">
                          <label data-error="wrong" data-success="right" for="txtNomeDTF">Nome</label>
                          <div class="input-group">
                            <input type="text" class="input-default focus form-control" id="txtNomeDTF" name="txtNomeDTF" class="form-control" placeholder="Nome">
                          </div>
                        </div>

                        <div class="col-lg-3  col-12 form-group">
                          <label data-error="wrong" data-success="right" for="txtQtdeProgDTF">Qtde Prog</label>
                          <div class="input-group">
                            <input type="text" class="input-default focus form-control" id="txtQtdeProgDTF" name="txtQtdeProgDTF" class="form-control" placeholder="Qtde Prog">
                          </div>
                        </div>

                        <div class="col-lg-3  col-12 form-group">
                          <label data-error="wrong" data-success="right" for="txtAlturaDTF">Altura</label>
                          <div class="input-group">
                            <input type="text" class="input-default focus form-control" id="txtAlturaDTF" name="txtAlturaDTF" class="form-control" placeholder="Altura">
                          </div>
                        </div>

                        <div class="col-lg-3  col-12 form-group">
                          <label data-error="wrong" data-success="right" for="txtLarguraDTF">Largura</label>
                          <div class="input-group">
                            <input type="text" class="input-default focus form-control" id="txtLarguraDTF" name="txtLarguraDTF" class="form-control" placeholder="Largura">
                          </div>
                        </div>

                        <div class="col-lg-3  col-12 form-group">
                          <label data-error="wrong" data-success="right" for="txtTotalPecasDTF">Total Peças</label>
                          <div class="input-group">
                            <input type="text" class="input-default focus form-control" id="txtTotalPecasDTF" name="txtTotalPecasDTF" class="form-control" placeholder="Total Peças">
                          </div>
                        </div>

                        <div class="col-lg-1  col-12 form-group">
                          <button id="btnRemoveDTF" class="btn btn-danger" style="margin-top: 28px"> « </button>
                        </div>

                        <div class="col-lg-1  col-12 form-group">
                          <button id="btnAddDTF" class="btn btn-danger" style="margin-top: 28px"> » </button>
                        </div>

                      </div>
                    </div>


                    <div class="col-lg-6 form-group border-Field">
                      <label style="margin-top: 17px" data-error="wrong" data-success="right" for="tabelaDTF">DTF</label>
                      <table id="tabelaDTF" class="display table table-sm" width="100%" style="width:100%">
                      </table>
                    </div>

                  </div>
                </div>

              </div>

            </div>

            <!-- grade -->
            <div class="tab-pane fade" id="divGrade" role="tabpanel" aria-labelledby="tabGrade">
              <div class="row col-12">
                <div class="col-lg-6 col-sm-6 form-group">
                  <label data-error="wrong" data-success="right" for="txtCorGrade">Cor</label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control" id="txtCorGrade" name="txtCorGrade" class="form-control" placeholder="Cor">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnCorGrade" name="btn-representante" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnACorGrade" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>

                <div class="col-lg-6 col-sm-6 form-group">
                  <label data-error="wrong" data-success="right" for="txtFaixa">Faixa</label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control" disabled id="txtFaixa" name="txtFaixa" class="form-control" placeholder="Faixa">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnFaixa" name="btn-representante" disabled data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnAFaixa" disabled type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
                <div class="col-lg-9 col-sm-9 form-group divTabelaGrade">
                  <div class="row d-flex justify-content-end" style="margin-top: 15px;">


                    <div class="col-lg-12 form-group" style="margin-top: 14px;">
                      <table id="tabelaGrade" class="display table table-sm" width="100%" style="width:100%">
                      </table>
                    </div>

                    <div class="col-lg-2 col-sm-2 form-group">
                      <label data-error="wrong" data-success="right" for="txtQtdeTotal">Qtde. total</label>
                      <div class="input-group">
                        <input type="text" value="0.00" disabled class="input-default focus form-control text-right" id="txtQtdeTotal" name="txtQtdeTotal" class="form-control" placeholder="Qtde. total">
                      </div>
                    </div>

                    <div class="col-lg-2 col-sm-2 form-group">
                      <label data-error="wrong" data-success="right" for="txtValTotal">Valor total</label>
                      <div class="input-group">
                        <input type="text" value="0.00" disabled class="input-default focus form-control text-right" id="txtValTotal" name="txtValTotal" class="form-control" placeholder="Valor total">
                      </div>
                    </div>
                  </div>
                </div>
                <div class="col-lg-3 col-sm-3 form-group" id="divIndices">
                  <div class="row d-flex justify-content-end">
                    <div class="col-lg-12 form-group">
                      <label data-error="wrong" data-success="right" for="tabelaIndices">Índices</label>
                      <table id="tabelaIndices" class="display table table-sm" width="100%" style="width:100%">
                      </table>
                    </div>

                    <div class="col-lg-auto col-sm-auto form-group">
                      <label data-error="wrong" data-success="right" for="txtIndiceTotal">Indice total</label>
                      <div class="input-group">
                        <input type="text" value="0.00" disabled class="input-default focus form-control text-right" id="txtIndiceTotal" name="txtIndiceTotal" class="form-control" placeholder="Valor total">
                      </div>
                    </div>

                  </div>

                </div>
              </div>
            </div>

            <!-- observações -->
            <div class="tab-pane fade" id="divObs" role="tabpanel" aria-labelledby="tabObs">
              <div class="row" style="margin-top: 15px;">

                <div class="col-lg-4 col-4 form-group">
                  <label data-error="wrong" data-success="right" for="txtObsProduto">Observações Produto</label>
                  <textarea style="resize: none" id="txtObsProduto" placeholder="Observações Produto" class="input-default focus form-control" rows="8"></textarea>
                </div>

                <div class="col-lg-4 col-4 form-group">
                  <label data-error="wrong" data-success="right" for="txtObsProducao">Observações Produção</label>
                  <textarea style="resize: none" id="txtObsProducao" placeholder="Observações Produção" class="input-default focus form-control" rows="8"></textarea>
                </div>

                <div class="col-lg-4 col-4 form-group">
                  <label data-error="wrong" data-success="right" for="txtObsEspecificacoes">Observações Especificações</label>
                  <textarea style="resize: none" id="txtObsEspecificacoes" placeholder="Observações Especificações" class="input-default focus form-control" rows="8"></textarea>
                </div>

              </div>
            </div>

            <!-- ficha técnica -->
            <div class="tab-pane fade" id="divFt" role="tabpanel" aria-labelledby="tabFt">
              <div class="row" style="margin-top: 15px;">

                <div class="col-lg-12 form-group">
                  <table id="tabelaFt" class="display table table-sm" width="100%" style="width:100%">
                  </table>
                </div>

              </div>
            </div>

          </div>
        </div>
        <div class="modal-footer">
          <div class="row">
            <div class="col-sm-12">
              <button id="btnDesistirInfos" class="btn btn-sisp btn-danger mr-2" data-dismiss="modal"> Desistir </button>
              <button id="btnConfirmarInfos" class="btn btn-sisp btn-primary"> Confirmar </button>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div id="modalComposicao" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-md">
      <div class="modal-content">
        <div class="modal-header">
          <h4 class="modal-title">Adicionar Composição</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <div class="row">

            <div class="col-lg-12 col-sm-12 form-group">
              <label data-error="wrong" data-success="right" for="txtFornecedor">Fornecedor</label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control" id="txtFornecedor" name="txtFornecedor" class="form-control" placeholder="Fornecedor">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btnFornecedor" name="btnFornecedor" data-button="absolute" type="button">
                    <i class="m-0 p-0 fas fa-search"></i>
                  </button>
                  <button class="btn bg-danger" id="btnAFornecedor" type="button">
                    <i class="m-0 p-0 fas fa-trash"></i>
                  </button>
                </div>
              </div>
            </div>

            <div class="col-lg-12 col-sm-12 form-group">
              <label data-error="wrong" data-success="right" for="txtMaterial">Material</label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control" id="txtMaterial" name="txtMaterial" class="form-control" placeholder="Material">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btnMaterial" name="btn-representante" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btnAMaterial" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>

            <div class="col-lg-12 col-sm-12 form-group">
              <label data-error="wrong" data-success="right" for="txtCorItem">Cor</label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control" id="txtCorItem" name="txtCorItem" class="form-control" placeholder="Cor">
                <input type="text" class="input-default focus form-control d-none" id="txtOpcionalItem" name="txtOpcionalItem" class="form-control" placeholder="Cor">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btnCor" name="btn-representante" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i> </button>
                  <button class="btn bg-danger" id="btnACor" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>

          </div>
        </div>
        <div class="modal-footer">
          <div class="row">
            <div class="col-sm-12">
              <button id="btnConfirmarComposicao" class="btn btn-danger"> Confirmar </button>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div id="modalConsumo" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-md">
      <div class="modal-content">
        <div class="modal-header">
          <h4 class="modal-title">Adicionar Consumo</h4>
          <div class="d-flex mt-2 ml-2">
            <div class="radio-group form-radio icheck-primary"><input type="radio" id="rgProduto" name="rgTipoConsumo" class="rgTipoConsumo inputConsumo"><label for="rgProduto">Produto</label></div>
            <div class="radio-group form-radio icheck-primary"><input type="radio" checked id="rgMaterial" name="rgTipoConsumo" class="rgTipoConsumo inputConsumo"><label for="rgMaterial">Material</label></div>
          </div>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <div class="row">

            <div class="col-lg-12 col-sm-12 form-group" id="divMaterialConsumo">
              <label data-error="wrong" data-success="right" for="txtMaterialConsumo">Material: *</label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control inputConsumo" id="txtMaterialConsumo" name="txtMaterialConsumo" class="form-control" placeholder="Material">
                <div class="input-group-append">
                  <button class="btn bg-danger inputConsumo" id="btnMaterialConsumo" name="btn-representante" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger inputConsumo" id="btnAMaterialConsumo" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>

            <div class="col-lg-12 col-sm-12 form-group d-none" id="divProdutoConsumo">
              <label data-error="wrong" data-success="right" for="txtProdutoConsumo">Produto: *</label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control inputConsumo" id="txtProdutoConsumo" name="txtProdutoConsumo" class="form-control" placeholder="Produto">
                <div class="input-group-append">
                  <button class="btn bg-danger inputConsumo" id="btnProdutoConsumo" name="btn-representante" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger inputConsumo" id="btnAProdutoConsumo" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>

            <div class="col-lg-12 col-sm-12 form-group">
              <label data-error="wrong" data-success="right" for="txtCorConsumo">Cor: *</label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control" id="txtCorConsumo" name="txtCorConsumo" class="form-control" placeholder="Cor">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btnCorConsumo" name="btn-representante" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i> </button>
                  <button class="btn bg-danger" id="btnACorConsumo" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>

            <div class="col-lg-12 col-sm-12 form-group">
              <label data-error="wrong" data-success="right" for="txtSetorConsumo">Setor:</label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control inputConsumo" id="txtSetorConsumo" name="txtSetorConsumo" class="form-control" placeholder="Setor">
                <div class="input-group-append">
                  <button class="btn bg-danger inputConsumo" id="btnSetorConsumo" name="btn-representante" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i> </button>
                  <button class="btn bg-danger inputConsumo" id="btnASetorConsumo" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>

            <div class="col-lg-6  col-sm-12 form-group">
              <label data-error="wrong" data-success="right" for="txtQtdeConsumo">Qtde: *</label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control maskConsumos inputConsumo" id="txtQtdeConsumo" name="txtQtdeConsumo" class="form-control" placeholder="Qtde">
              </div>
            </div>

            <div class="col-lg-6  col-sm-12 form-group">
              <label data-error="wrong" data-success="right" for="txtCustoUniConsumo">Custo Uni.: </label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control maskConsumos inputConsumo" id="txtCustoUniConsumo" name="txtCustoUniConsumo" class="form-control" placeholder="Custo Uni.">
                <input type="text" class="input-default focus form-control d-none" id="txtDivisorConsumo" name="txtDivisorConsumo" class="form-control" placeholder="Custo Uni.">
                <input type="text" class="input-default focus form-control d-none" id="txtCodOpcional" name="txtCodOpcional" class="form-control" placeholder="Custo Uni.">
              </div>
            </div>

          </div>
        </div>
        <div class="modal-footer">
          <div class="row">
            <div class="col-sm-12">
              <button id="btnConfirmarConsumo" class="btn btn-danger"> Confirmar </button>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>


  <!-- Control Sidebar -->
  <aside class="control-sidebar control-sidebar-dark">
    <!-- Control sidebar content goes here -->
  </aside>
  <?php
  include_once('../../../modais.php');
  include_once('../../../modals/modal_entid_simpl.html');
  include_once('../../../modals/modal_anexos.html');
  include_once('../../../modals/modal_cliente.php');
  ?>
  </div>

  <!-- jQuery -->
  <script src="../plugins/jquery/jquery.min.js?versao=3.2511.19.1"></script>
  <!-- jQuery UI 1.11.4 -->
  <script src="../plugins/jquery-ui/jquery-ui.min.js?versao=3.2511.19.1"></script>
  <script type="text/javascript" src="../dist/js/jquery.dataTables.js?versao=3.2511.19.1"></script>
  <script type="text/javascript" src="../dist/js/dataTables.bootstrap4.min.js?versao=3.2511.19.1"></script>
  <!-- SweetAlert2 -->
  <script src="../plugins/sweetalert2/sweetalert2.min.js?versao=3.2511.19.1"></script>
  <script src="../plugins/toastr/toastr.min.js?versao=3.2511.19.1"></script>

  <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
  <script>
    $.widget.bridge('uibutton', $.ui.button);
  </script>

  <script src="../plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.2511.19.1"></script>

  <script src="../dist/js/adminlte.min.js?versao=3.2511.19.1"></script>
  <script src="../dist/js/requisicoes.js?versao=3.2511.19.1"></script>
  <script src="../dist/js/cliente/entidade.js?versao=3.2511.19.1"></script>
  <script src="../dist/js/loadingoverlay.min.js?versao=3.2511.19.1"></script>
  <script src="../dist/js/valida_cpf_cnpj.js?versao=3.2511.19.1"></script>
  <script src="../plugins/jquery-validation/jquery.validate.min.js?versao=3.2511.19.1"></script>
  <script src="../dist/js/sisplan.js?versao=3.2511.19.1"></script>
  <script src="../dist/js/popper.min.js?versao=3.2511.19.1"></script>
  <script src="../dist/js/tippy-bundle.umd.js?versao=3.2511.19.1"></script>
  <script src="../utils/funcoes.js?versao=3.2511.19.1"></script>
  <script src="../dist/js/jquery.mask.min.js?versao=3.2511.19.1"></script>
  <script src="../dist/js/jquery.maskMoney.min.js?versao=3.2511.19.1"></script>
  <script src="../utils/cookies.js?versao=3.2511.19.1"></script>
  <script src="../dist/js/driver.min.js?versao=3.2511.19.1"></script>
  <script src="../dist/js/dataTables.keyTable2.js?versao=3.2511.19.1"></script>
  <script type="text/javascript" src="../modals/modal_entid_simpl.js?versao=3.2511.19.1"></script>
  <script type="text/javascript" src="../modals/modal_anexos.js?versao=3.2511.19.1"></script>
  <script type="text/javascript" src="../config.js?versao=3.2511.19.1"></script>
  <script type="text/javascript" src="../dist/js/sum().js"></script>
  <!-- Production -->
  <script type="text/javascript">
    $(document).ready(async function() {

      if (getCookie('usuario') == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
      }

      let usuario = getCookie('usuario');
      let empresa = getCookie('empresa');

      ipInterno = IP_INTERNO;
      ipExterno = IP_EXTERNO;
      basicAuth = BASIC_AUTH;

      const temAcesso = await temAcessoTela('ORCAMENTO');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, BASE_URI);
        return;
      }

      sArquivo = `${BASE_URI}/pages/orcamento/cadastro_orcamento/orcamento.js?versao=3.2511.19.1`;
      insereJavaScriptPagina(sArquivo);

    });
  </script>
</body>

</html>